/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;

public final class Colorize
implements ImageFilter {
    private final Color c;

    public Colorize(Color color) {
        this.c = color;
    }

    public Colorize(Color color, float f2) {
        this(color, (int)(255.0f * f2));
    }

    public Colorize(Color color, int n) {
        if (n > 255 || n < 0) {
            throw new IllegalArgumentException("Specified alpha value is outside the range of allowed values.");
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = n;
        this.c = new Color(n2, n3, n4, n5);
    }

    public BufferedImage apply(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImageBuilder(n, n2).build();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setColor(this.c);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

